/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/**
 * \file    ddr3.c
 *
 * \brief   Support routines for DDR test application
 *
 * This file contains the support function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_EVM.h"
#include "ddr3.h"


/*
 *====================
 * Function implementations
 *====================
 */
 
 /** **************************************************************************
 * \n \brief Routine to initialize ddr3
 *
 * 
 */

void ddr3_init( )
{
    /* TODO - ddr3 initialization to be done as part of GEL file.
     *	      Check, how to do it...
     */
}

/** **************************************************************************
 * \n \brief Routine to read from DDR3  memory
 * 
 * This routine reads from DDR3 memory.This routine takes buffer pointer as a 
 * parameter  from where data to be read along with that it contains buffer 
 * to copy read data and length of the buffer.
 *
 * \param   *pSrc  [IN]  buffer pointer to read data
 * \param   *pDSt  [IN]  buffer pointer to copy read data
 * \param   length [IN]  length of the buffer
 *
 */
 
void ddr3_read( UINT16 *pSrc, UINT16 *pDst, UINT32 length )
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
	    	length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++; pDst++;
	    	length -= 2;
		}
    }
}
/** **************************************************************************
 * \n \brief Routine to write into ddr3
 *
 * This routine writes into ddr3.This routine takes pSrc buffer pointer as a 
 * parameter which contains data to be copied along with that pDst buffer 
 * pointer  which contains the address where to copy and lenght of the buffer
 *
 *
 * \param *pSrc   [IN]   buffer to be written into ddr3
 * \param *pDst   [IN]   address where data to be written
 * \param length  [IN]   length of the buffer
 *
 *  
 */

void ddr3_write( UINT16 *pSrc, UINT16 *pDst, UINT32 length )
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
		    length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++;  pDst++;
	    	length -= 2;
		}
    }
}
